<?php
global $post;

// If not $_POST get the current values to edit
if ( ! $_POST ) {
	$postId                 = Tribe__Events__Main::postIdHelper();
	$venue_name             = tribe_get_venue();
	$_VenuePhone            = tribe_get_phone();
	$_VenueURL              = strip_tags( tribe_get_venue_website_link( null, null ) );
	$_VenueAddress          = tribe_get_address();
	$_VenueCity             = tribe_get_city();
	$_VenueProvince         = tribe_get_province();
	$_VenueState            = tribe_get_state();
	$_VenueCountry          = tribe_get_country();
	$_VenueZip              = tribe_get_zip();
	$google_map_link_toggle = get_post_meta( $postId, '_EventShowMapLink', true );
	$google_map_toggle      = tribe_embed_google_map( $postId );

	//If we just saved use those values from $_POST
} elseif ( ! empty( $_POST ) ) {
	$venue_name             = isset( $_POST['venue']['Venue'] ) ? esc_attr( $_POST['venue']['Venue'] ) : '';
	$_VenuePhone            = isset( $_POST['venue']['Phone'] ) ? esc_attr( $_POST['venue']['Phone'] ) : '';
	$_VenueURL              = isset( $_POST['venue']['URL'] ) ? esc_attr( $_POST['venue']['URL'] ) : '';
	$_VenueAddress          = isset( $_POST['venue']['Address'] ) ? esc_attr( $_POST['venue']['Address'] ) : '';
	$_VenueCity             = isset( $_POST['venue']['City'] ) ? esc_attr( $_POST['venue']['City'] ) : '';
	$_VenueProvince         = isset( $_POST['venue']['Province'] ) ? esc_attr( $_POST['venue']['Province'] ) : '';
	$_VenueState            = isset( $_POST['venue']['State'] ) ? esc_attr( $_POST['venue']['State'] ) : '';
	$_VenueCountry          = isset( $_POST['venue']['Country'] ) ? esc_attr( $_POST['venue']['Country'] ) : '';
	$_VenueZip              = isset( $_POST['venue']['Zip'] ) ? esc_attr( $_POST['venue']['Zip'] ) : '';
	$google_map_link_toggle = isset( $_POST['EventShowMapLink'] ) ? esc_attr( $_POST['EventShowMapLink'] ) : '';
	$google_map_toggle      = isset( $_POST['EventShowMap'] ) ? esc_attr( $_POST['EventShowMap'] ) : '';
}
?>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'Address:', 'the-events-calendar' ); ?></td>
	<td>
		<input
			tabindex="<?php tribe_events_tab_index(); ?>"
			type='text'
			name='venue[Address][]'
			size='25'
			value='<?php echo ( isset( $_VenueAddress ) ? esc_attr( $_VenueAddress ) : '' ); ?>'
			aria-label="<?php esc_html_e( 'Venue Address', 'the-events-calendar' ); ?>"
		/>
	</td>
</tr>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'City:', 'the-events-calendar' ); ?></td>
	<td>
		<input
			tabindex="<?php tribe_events_tab_index(); ?>"
			type='text'
			name='venue[City][]'
			size='25'
			value='<?php echo ( isset( $_VenueCity ) ? esc_attr( $_VenueCity ) : '' ); ?>'
			aria-label="<?php esc_html_e( 'Venue City', 'the-events-calendar' ); ?>"
		/>
	</td>
</tr>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'Country:', 'the-events-calendar' ); ?></td>
	<td>
		<?php
		$countries = Tribe__View_Helpers::constructCountries( $post->ID );

		if ( isset( $_VenueCountry ) && $_VenueCountry ) {
			$current = $_VenueCountry;
		} else {
			$current = null;
		}

		if ( is_array( $current ) && isset( $current[1] ) ) {
			$current = $current[1];
		}
		?>
		<select
			class="tribe-dropdown"
			tabindex="<?php tribe_events_tab_index(); ?>"
			name='venue[Country][]'
			id="EventCountry"
			aria-label="<?php esc_html_e( 'Venue Country', 'the-events-calendar' ); ?>"
			
		>
			<?php
			foreach ( $countries as $abbr => $fullname ) {
				if ( $abbr == '' ) {
					echo '<option value="">' . esc_html( $fullname ) . '</option>';
				} else {
					echo '<option value="' . esc_attr( $fullname ) . '" ' . selected( ( $current == $fullname ), true, false ) . '>' . esc_html( $fullname ) . '</option>';
				}
			}
			?>
		</select>
	</td>
</tr>
<tr class="linked-post venue">
	<?php
	if ( ! isset( $_VenueStateProvince ) || $_VenueStateProvince == '' ) {
		$_VenueStateProvince = - 1;
	}
	$currentState = ( $_VenueStateProvince == - 1 ) ? '' : $_VenueStateProvince;
	$currentProvince = empty( $_VenueProvince ) ? '' : $_VenueProvince;
	?>
	<td class='tribe-table-field-label'><?php esc_html_e( 'State or Province:', 'the-events-calendar' ); ?></td>
	<td>
		<input tabindex="<?php tribe_events_tab_index(); ?>" id="StateProvinceText" name="venue[Province][]" type='text' name='' size='25' value='<?php echo esc_attr( $currentProvince ); ?>' aria-label="<?php esc_html_e( 'Venue State', 'the-events-calendar' ); ?>" />
		<select
			class="tribe-dropdown"
			tabindex="<?php tribe_events_tab_index(); ?>"
			id="StateProvinceSelect"
			name="venue[State]"
			aria-label="<?php esc_html_e( 'Venue State', 'the-events-calendar' ); ?>"
		>
			<option value=""><?php esc_html_e( 'Select a State:', 'the-events-calendar' ); ?></option>
			<?php
			foreach ( Tribe__View_Helpers::loadStates() as $abbr => $fullname ) {
				echo '<option value="' . esc_attr( $abbr ) . '"' . selected( ( ( $_VenueStateProvince != - 1 ? $_VenueStateProvince : $currentState ) == $abbr ), true, false ) . '>' . esc_html( $fullname ) . '</option>';
			}
			?>
		</select>
	</td>
</tr>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'Postal Code:', 'the-events-calendar' ); ?></td>
	<td>
		<input
			tabindex="<?php tribe_events_tab_index(); ?>"
			type='text'
			id='EventZip'
			name='venue[Zip][]'
			size='6'
			value='<?php echo ( isset( $_VenueZip ) ? esc_attr( $_VenueZip ) : '' ); ?>'
			aria-label="<?php esc_html_e( 'Venue Zip Code', 'the-events-calendar' ); ?>"
		/>
	</td>
</tr>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'Phone:', 'the-events-calendar' ); ?></td>
	<td>
		<input
			tabindex="<?php tribe_events_tab_index(); ?>"
			type='text'
			id='EventPhone'
			name='venue[Phone][]'
			size='14'
			value='<?php echo ( isset( $_VenuePhone ) ? esc_attr( $_VenuePhone ) : '' ); ?>'
			aria-label="<?php esc_html_e( 'Venue Phone', 'the-events-calendar' ); ?>"
		/>
	</td>
</tr>
<tr class="linked-post venue">
	<td class='tribe-table-field-label'><?php esc_html_e( 'Website:', 'the-events-calendar' ); ?></td>
	<td>
		<input
			tabindex="<?php tribe_events_tab_index(); ?>"
			type='text'
			id='EventWebsite'
			name='venue[URL][]'
			size='14'
			value='<?php echo ( isset( $_VenueURL ) ? esc_attr( $_VenueURL ) : '' ); ?>'
			aria-label="<?php esc_html_e( 'Venue URL', 'the-events-calendar' ); ?>"
		/>
	</td>
</tr>

<?php
$google_map_toggle = false;
$google_map_link_toggle = false;

if ( empty( $post->post_type ) || $post->post_type != Tribe__Events__Main::VENUE_POST_TYPE ) {
	if ( tribe_get_option( 'embedGoogleMaps', true ) ) { // Only show if embed option selected
		$google_map_toggle = ( tribe_embed_google_map( $post->ID ) || get_post_status( $post->ID ) == 'auto-draft' ) ? true : false;
		?>
		<tr id="google_map_toggle" class="remain-visible">
			<td class='tribe-table-field-label'><?php esc_html_e( 'Show Google Map:', 'the-events-calendar' ); ?></td>
			<td>
				<input
					tabindex="<?php tribe_events_tab_index(); ?>"
					type="checkbox"
					id="EventShowMap"
					name="venue[EventShowMap][]"
					value="1"
					<?php checked( $google_map_toggle ); ?>
					aria-label="<?php esc_html_e( 'Show Google Map?', 'the-events-calendar' ); ?>"
				/>
			</td>
		</tr>
	<?php
	}
	$google_map_link_toggle = ( get_post_status( $post->ID ) == 'auto-draft' && $google_map_toggle ) ? true : get_post_meta( $post->ID, '_EventShowMapLink', true );
	?>
	<tr id="google_map_link_toggle" class="remain-visible">
		<td class='tribe-table-field-label'><?php esc_html_e( 'Show Google Maps Link:', 'the-events-calendar' ); ?></td>
		<td>
			<input
				tabindex="<?php tribe_events_tab_index(); ?>"
				type="checkbox"
				id="EventShowMapLink"
				name="venue[EventShowMapLink][]"
				value="1"
				<?php checked( $google_map_link_toggle ); ?>
				aria-label="<?php esc_html_e( 'Show Google Map Link?', 'the-events-calendar' ); ?>"
			/>
		</td>
	</tr>
	<?php
} else {
	if ( tribe_get_option( 'embedGoogleMaps', true ) ) { // Only show if embed option selected

		$google_map_toggle = ( tribe_embed_google_map( $post->ID ) || get_post_status( $post->ID ) == 'auto-draft' ) ? true : false;
		?>
		<tr id="google_map_toggle" class="remain-visible">
			<td class='tribe-table-field-label'><?php esc_html_e( 'Show Google Map:', 'the-events-calendar' ); ?></td>
			<td>
				<input
					tabindex="<?php tribe_events_tab_index(); ?>"
					type="checkbox"
					id="VenueShowMap"
					name="venue[ShowMap][]"
					value="true"
					<?php checked( $google_map_toggle ); ?>
				/>
			</td>
		</tr>
	<?php
	}
	$google_map_link_toggle = ( get_post_meta( $post->ID, '_VenueShowMapLink', true ) !== 'false' || get_post_status( $post->ID ) == 'auto-draft' ) ? true : false;
	?>
	<tr id="google_map_link_toggle" class="remain-visible">
		<td class='tribe-table-field-label'><?php esc_html_e( 'Show Google Maps Link:', 'the-events-calendar' ); ?></td>
		<td>
			<input
				tabindex="<?php tribe_events_tab_index(); ?>"
				type="checkbox"
				id="VenueShowMapLink"
				name="venue[ShowMapLink][]"
				value="true"
				<?php checked( $google_map_link_toggle ); ?>
			/>
		</td>
	</tr>
	<?php
}
